
async function withActiveTab(fn){
  const [tab]=await chrome.tabs.query({active:true,currentWindow:true});
  if(!tab?.id) return null;
  return fn(tab);
}
document.getElementById('guard').addEventListener('click',()=>withActiveTab(tab=>{
  chrome.tabs.sendMessage(tab.id,{type:'MZ_GUARD_ONCE'});
}));
document.getElementById('open').addEventListener('click',()=>withActiveTab(tab=>{
  chrome.tabs.sendMessage(tab.id,{type:'MZ_TOGGLE_SIDEBAR'});
}));
